#!/bin/zsh
clear
echo "\033[1mQuickLook für EPS-Dateien aktivieren (ab macOS 12)\033[0m" 
echo "© 2023 Wolfgang Kreutz für Mac & i\n"
echo "Dieses Shell-Skript kopiert das in macOS enthaltene, aber schreibgeschützte QuickLook-Plug-in für Illustrator-Dateien in den Ordner ~/Library/QuickLook. Danach wird die darin enthaltene Datei „Info.plist“ so modifiziert, dass sich das Plug-in auch für EPS- und PS-Dateien zuständig fühlt.\n" | fmt -w $(tput cols)
read -sk "?Zum Fortfahren Return-Taste drücken oder zum Abbrechen das Fenster schließen ..."

echo "\n\n- QuickLook-Plug-in für Illustrator-Dateien aus dem System-Ordner in die User-Library kopieren …" | fmt -w $(tput cols)
cp -R /System/Library/QuickLook/Illustrator.qlgenerator ~/Library/QuickLook

echo "\n- Plist-Datei um UTI (Uniform Type Identifier) für EPS-Dateien ergänzen …" | fmt -w $(tput cols)
sed -i '' '16i\
				<string>com.adobe.encapsulated-postscript</string>\
' ~/Library/QuickLook/Illustrator.qlgenerator/Contents/Info.plist

echo "\n- Plist-Datei um UTI für PS-Dateien ergänzen …" | fmt -w $(tput cols)
sed -i '' '16i\
				<string>com.adobe.postscript</string>\
' ~/Library/QuickLook/Illustrator.qlgenerator/Contents/Info.plist

echo "\n- QuickLook-Dienst neu starten …"
qlmanage -r

echo "\n\033[1mFERTIG:\033[0m"
echo "macOS 12 oder höher sollte nun wieder eine Vorschau für EPS-/PS-Dateien anzeigen. Es empfiehlt sich, den Mac neu zu starten oder zumindest den Benutzer ab- und wieder anzumelden." | fmt -w $(tput cols)
